/// <reference name="MicrosoftAjax.debug.js" />
/// <reference path="jquery-1.3.2-vsdoc.js" />
/// <reference name="ajax.search.js" />

var isSearching = false;
var currentData;

var SearchType = {
    Activity: 0,
    Itinerary: 1,
    ActivityItinerary: 2
};

var OrderBy = {
    Relevance: 0,
    Popularity: 1,
    Rating: 2,
    Distance: 3,
};

Sys.Application.add_init(function() {
    $("input[type=text]:visible").focus();

    // autocomplete boxes
    var autocompleteOptions = {
        extraParams: { state: function() { return $("#State").val(); } },
        width: 170,
        minChars: 2,
        limit: 30,
        cacheLength: 0,
        dataType: 'json',
        parse: function(items) {
	        var parsed = [];
	        for (var i = 0; i < items.length; i++)
	            parsed[i] = { data: [items[i]], value: items[i], result: [items[i]] };
	        return parsed;
        }
    };
    $("#City").attr("autocomplete", "off");
    $("#City").autocomplete(baseUrl + "Search/Cities", autocompleteOptions);
    $("#Zip").attr("autocomplete", "off");
    $("#Zip").autocomplete(baseUrl + "Search/ZipCodes",autocompleteOptions);

    // Enable browser history
    Sys.Application.set_enableHistory(true);
    Sys.Application.add_navigate(function(sender, e) {
        // only do after page load and if anchorstring if found
        if (isSearching) return;

        // get criteria and cleanup
        var criteria = e.get_state();
        if (criteria.City) criteria.City = criteria.City.replace(/\+/g, " ");
        if (criteria.StreetAddress) criteria.StreetAddress = criteria.StreetAddress.replace(/\+/g, " ");
        if (criteria.Query) criteria.Query = criteria.Query.replace(/\+/g, " ");

        // update fields to reflect criteria
        if (criteria.Query) {
            // simple
            $("#searchForm .simpleSearch").show();
            $("#searchForm .advancedSearch").hide();
            $("#Query").val(criteria.Query ? criteria.Query : "");
        } else {
            // advanced
            $("#searchForm .simpleSearch").hide();
            $("#searchForm .advancedSearch").show();
            
            selectedTypeIdOpt = $("#ActivityTypeId option[value=" + criteria.ActivityTypeId + "]");
            selectedStateOpt = $("#State option[value=" + criteria.State + "]");
            selectedRadiusOpt = $("#Radius option[value=" + criteria.Radius + "]");
            if (selectedTypeIdOpt.length == 0) selectedTypeIdOpt = $("#ActivityTypeId option:first-child");
            if (selectedStateOpt.length == 0) selectedStateOpt = $("#State option:first-child");
            if (selectedRadiusOpt.length == 0) selectedRadiusOpt = $("#Radius option:first-child");
            selectedTypeIdOpt[0].selected = true;
            selectedStateOpt[0].selected = true;
            selectedRadiusOpt[0].selected = true;
            $("#City").val(criteria.City ? criteria.City : "");
            $("#Zip").val(criteria.Zip ? criteria.Zip : "");
            $("#StreetAddress").val(criteria.StreetAddress ? criteria.StreetAddress : "");
        }

        var form = $("#searchForm form:visible");       // active form
        var searchUrl = form[0].action + "?" + decodeURI(location.href.split("#")[1]);
        updateModel(searchUrl, null, onSearchRequest, onSearchResponse);
    });

    // activity templates
    $create(Sys.UI.DataView, null, null, null, $get("dynamicActivitiesItems"));         // list
    $create(Sys.UI.DataView, null, null, null, $get("dynamicActivitiesPager"));         // pager
    $create(Sys.UI.DataView, null, null, null, $get("dynamicActivitiesSort"));          // sort by

    // itinerary templates
    $create(Sys.UI.DataView, null, null, null, $get("dynamicItinerariesItems"));         // list
    $create(Sys.UI.DataView, null, null, null, $get("dynamicItinerariesPager"));         // pager
    
    // error template
    $create(Sys.UI.DataView, null, null, null, $get("errorTemplate"));

    // auto-search on some field change
    function autoRefresh() {
        if (isSearching) return;
        var form = $("#searchForm form:visible");
        var url = form[0].action + "?" + form.serialize();
        updateModel(url, null, onSearchFormRequest, onSearchResponse);
    };

    $("#State").bind("change", autoRefresh);
    $("#ActivityTypeId").bind("change", autoRefresh);
    $("#City").bind("result", autoRefresh);
    $("#Zip").bind("result", autoRefresh);
    $("#Radius").bind("change", autoRefresh);
    $("#StreetAddress").bind("change", autoRefresh);


    // intercept form to prevent from posting, and enable ajax calls instead
    updateModelOnFormSubmit($("#searchForm form"), onSearchFormRequest, onSearchResponse);

    // intercept search type change (activities | itineraries)
    updateResultsTabLinks();
    updateModelOnClickLink($(".searchResults h2 a"), onSearchRequest, onSearchResponse, null);

    // intercept pager & sorter links to prevent them from loading, and enable ajax calls instead
    updateModelOnClickLink($(".searchResults .pager a"), onSearchRequest, onSearchResponse);
    updateModelOnClickLink($(".searchResults .subheader a"), onSearchRequest, onSearchResponse);

    // hook on activity related itineraries link
    updateSearchByActivityLinks($(".searchResults ul.activities a.relatedItineraries"));

    // enable toggle activities in itinerary results (if any)
    ajaxItineraryActivities($(".searchResults ul.itineraries"));
});

// invoked before creating the xhr request after clicking on link.
function onSearchRequest(href) {
    isSearching = true;     // flag to avoid cyclic calling when adding history point.
    var criteria = getCriteriaFromUri(href);
    Sys.Application.addHistoryPoint(criteria);
    updateResultsTabLinks();
    showPreloading();
    return true;
}

// invoked before creating the xhr request after submitting a form. This callback can cancel the actual request, useful for client-side validation
function onSearchFormRequest(href) {
    if (!currentData || currentData.Criteria.Type != SearchType.ActivityItinerary) {
        // validate
        var criteria = getCriteriaFromUri(href);
        if (!criteria) return false;

        var advancedMode = !$("#Query").is(":visible");
        if (advancedMode) {
            if (isNaN(criteria.ActivityTypeId) || criteria.ActivityTypeId == 0) return false;
            if (!criteria.State) return false;
            if (!criteria.City && !criteria.Zip) return false;
        } else {
            if (!criteria.Query) return false;
        }
    }
    
    return onSearchRequest(href);
}

function onSearchError(data) {
        document.title = "Plan My Night - " + data.Message;        
        $find("errorTemplate").set_data(data);
        $("#searchResultsDynamic h2 ul").attr("class", "none");
        $("#resultsTemplateContainer").empty().append($("#errorTemplate").clone());
        updateModelOnClickLink($("#resultsTemplateContainer a.retry"), onSearchRequest, onSearchResponse);
}

// invoked when data is retrieved
function onSearchResponse(data) {
    isSearching = false;

    // move active template to templates container
    $("#resultsTemplateContainer #dynamicActivitiesResults").remove().appendTo($("#templates"));
    $("#resultsTemplateContainer #dynamicItinerariesResults").remove().appendTo($("#templates"));
    
    // prepare templates
    $("#searchResultsStatic").remove();
    $("#searchResultsDynamic").show();
    
    if(data.Status && data.Status == "error") {
        // error
        onSearchError(data);
        onSearchResultsBound();
        return;
    }
    
    currentData = data;

    // update form orderBy
    var orderBy = getOrderByName(currentData.Criteria.SortBy);
    $("#searchForm input[name='SortBy']").val(orderBy);

    // update form resultType
    $("#searchForm form:visible input[name=Type]").val(currentData.Criteria.Type);
    $("#searchResultsDynamic h2 ul").attr("class", "active" + getSearchTypeName(currentData.Criteria.Type));

    updateResultsTabLinks();
    
    // new title
    document.title = "Plan My Night - " + currentData.CriteriaDescription;

    var template;
    switch (currentData.Criteria.Type) {
        case SearchType.Activity:
            // ACTIVITIES
            template = $("#dynamicActivitiesResults");
            if (currentData.TotalPages == 0) $("#dynamicActivitiesEmpty").show();

            // rebind items
            $find("dynamicActivitiesItems").set_data(currentData.Items);

            // rating labels
            showRatingLabels($("#dynamicActivitiesItems"));

            // rebind pager
            $find("dynamicActivitiesPager").set_data(currentData);
            updateModelOnClickLink($("#dynamicActivitiesPager a"), onSearchRequest, onSearchResponse);
            
            // rebind sort
            $find("dynamicActivitiesSort").set_data({ orderBy: orderBy, timestamp: new Date() });
            updateModelOnClickLink($("#dynamicActivitiesSort a"), onSearchRequest, onSearchResponse);

            // hook on activity related itineraries link
            updateSearchByActivityLinks($("#dynamicActivitiesItems a.relatedItineraries"));
            break;

        case SearchType.ActivityItinerary:

        case SearchType.Itinerary:
            // ITINERARIES
            template = $("#dynamicItinerariesResults");
            if (currentData.TotalPages == 0) $("#dynamicItinerariesEmpty").show();

            // rebind items
            $find("dynamicItinerariesItems").set_data(currentData.Items);

            // rating labels
            showRatingLabels($("#dynamicItinerariesItems"));

            // enable toggle activities in itinerary results (if any)
            ajaxItineraryActivities($("#dynamicItinerariesItems"));

            // rebind pager
            $find("dynamicItinerariesPager").set_data(currentData);
            updateModelOnClickLink($("#dynamicItinerariesPager a"), onSearchRequest, onSearchResponse);
            break;
    }


    // remove from templates and set into active container
    template.remove();
    $("#resultsTemplateContainer").empty().append(template);
    template.show();
    
    // enable and hide preloader
    $(".searchResults .items").removeClass("loading").scrollTop(0);
    $(".searchResults .pager").removeClass("disabled");

    onSearchResultsBound();
};

function updateResultsTabLinks() {
    // update 'search itineraries' link
    var $form = $("#searchForm form:visible");
    var formAction = $form[0].action + "?" + $form.serialize();
    $(".searchResults .searchTypeActivity").attr("href", replaceQueryString(formAction, "Type", "Activity"));
    $(".searchResults .searchTypeItinerary").attr("href", replaceQueryString(formAction, "Type", "Itinerary"));
}

function updateSearchByActivityLinks($links) {
    var onPreRequest = function(url) {
        // back link
        var backLink;
        if (currentData) {
            var $form = $("#searchForm form:visible");
            backLink = $form[0].action + "?" + $form.serialize() + "&Page=" + currentData.CurrentPage;
        } else {
            backLink = location.href.split("#")[0];
        }
        
        $("#searchResultsDynamic h2 ul li.linkActivityItineraries a").attr("href", backLink);

        // show
        showPreloading();
        return true;
    };

    var onPostResponse = function(data) {
        $("#searchResultsDynamic h2 ul li.linkActivityItineraries span").text(data.SearchActivity.Name);
        onSearchResponse(data);
    };

    updateModelOnClickLink($links, onPreRequest, onPostResponse);
}

function showPreloading() {
    $("#dynamicActivitiesEmpty").hide();
    $("#dynamicItinerariesEmpty").hide();
    $(".searchResults .items").addClass("loading");
    $(".searchResults .pager").addClass("disabled");
    $("#searchForm .field-validation-error").hide();
}

function showRatingLabels(container) {
    container.find("span.rating").each(function() {
        var $el = $(this);
        $el.find("span").remove();
        $el.addClass("rating rating_" + $el.text().replace(".", "_"));
    });
}

function ajaxItineraryActivities(container) {
    container.find("p.children a.toggleActivities").each(function() {
        {
            this.onclick = function() {
                var url = this.href.split("#")[0];     // strip anchors
                var link = $(this);
                updateModel(
                    url,
                    null,
                    function() {
                        var container = link.parent(".children");
                        if (container.find("ul.activities").length > 0) {
                            container.find("ul.activities").slideToggle();
                            container.find(".bulkAdd").slideToggle();
                            return false;
                        }
                        
                        if(link.is(".loading")) return false;
                        link.addClass("loading");
                        
                        return true;
                    },
                    function(activities) {
                        link.removeClass("loading");
                        var container = link.parent(".children");
                        container.append($("#itineraryActivitiesTemplate").clone().attr("id", ""));

                        $create(Sys.UI.DataView, { data: activities.Activities }, null, null, container.find(".sys-template")[0]);

                        var $activitiesEl = container.find("ul.activities");
                        showRatingLabels($activitiesEl);

                        onSearchResultsBound(container);

                        $activitiesEl.hide().slideDown();

                        // hiajax bulk add
                        var bulkAdd = container.find(".bulkAdd").slideToggle()
                        updateModelOnClickLink(bulkAdd, activityActionRequest, activityActionResponse);
                    });
                return false;
            }
        }
    });
}

// helpers
function getCriteriaFromUri(href) {
    var parsedCriteria = Sys.Application._deserializeState(href.split("?")[1]);

    var criteria = {
        Query: null,
        Type: null,
        ActivityTypeId: null,
        StreetAddress: null,
        State: null,
        City: null,
        Zip: null,
        Radius: null,
        SortBy: null,
        Page: null
    };

    if (parsedCriteria.Query) criteria.Query = parsedCriteria.Query.replace(/\+/g, " ");
    if (parsedCriteria.StreetAddress) criteria.StreetAddress = parsedCriteria.StreetAddress.replace(/\+/g, " ");
    if (parsedCriteria.State) criteria.State = parsedCriteria.State;
    if (parsedCriteria.City) criteria.City = parsedCriteria.City.replace(/\+/g, " ");
    if (parsedCriteria.Zip) criteria.Zip = parsedCriteria.Zip;
    if (!isNaN(parsedCriteria.Radius) && parsedCriteria.Radius > 0) criteria.Radius = parsedCriteria.Radius;
    if (!isNaN(parsedCriteria.ActivityTypeId) && parsedCriteria.ActivityTypeId > 0) criteria.ActivityTypeId = parsedCriteria.ActivityTypeId;
    if (parsedCriteria.Type) criteria.Type = parsedCriteria.Type;
    if (parsedCriteria.SortBy) criteria.SortBy = parsedCriteria.SortBy;
    if (!isNaN(parsedCriteria.Page) && parsedCriteria.Page > 0) criteria.Page = parsedCriteria.Page;

    return criteria;
}

function getSearchTypeName(value) {
    for (var prop in SearchType) {
        if (SearchType[prop] == value) return prop;
    }
    
    return "";
}

function getOrderByName(value) {
    for (var prop in OrderBy) {
        if (OrderBy[prop] == value) return prop;
    }
    
    return "";
}

function replaceQueryString(url, param, value) {
    var re = new RegExp("([?|&])" + param + "=.*?(&|$)", "i");
    if (url.match(re))
        return url.replace(re, '$1' + param + "=" + value + '$2');
    else
        return url + '&' + param + "=" + value;
}

// converters
function activityRatingConverter(value) {
    var val = Math.round(value / 2);
    if (val % 1 == 0) {
        return val.toString() + ".0";
    } else {
        return val.toString()
    }
}

function sortByConverter(value, o) {
    var $form = $("#searchForm form:visible");
    var formAction = $form[0].action + "?" + $form.serialize();
    formAction = replaceQueryString(formAction, "SortBy", o.get_defaultValue());
    return formAction;
}

function dateConverter(value) {
    var date = parseMSJSONString(value);
    var dd = date.getDate();
    var mm = date.getMonth() + 1; //January is 0!
    var yyyy = date.getFullYear();
    return mm + "/" + dd + "/" + yyyy
}

function parseMSJSONString(msDate) {
    try {
        if (!msDate) return null;
        var date = new Date(parseInt(msDate.replace("/Date(", "").replace(")/", ""), 10));
        if (date.getFullYear() == 9999) date = null;
        return date;
    }
    catch (e) { return null; }
}

function friendlyTimeConverter(value) {
    if (value > 0) {
        var hours = Math.floor(value / 60);
        var minutes = value % 60;
        var time = "";
        if (hours > 0) time += hours + "h ";
        if (minutes > 0) time += minutes + "m";
        return time;
    }

    return "-";
}

// search results onBound callback (overrided in ajax.itineraries.js)
function onSearchResultsBound() { }